//
//  MCReportWebView.h
//  MCReporting
//
//  Created by Alykhan Jetha on 10-11-07.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <MCApplication/MCNibLoadingView.h>
#import <WebKit/WebKit.h>

@class MCReportWrapper;
@class MCReportWebAction;

@interface MCReportWebView : MCNibLoadingView {
	
	IBOutlet WebView *webview;	
	IBOutlet NSButton *backButton;
	
	NSString *rootURLstring;
	NSString *scratchURLstring;
	id response;
	
	MCReportWrapper *reportWrapper;
	id document;
	

}

@property (retain) MCReportWrapper *reportWrapper;
@property (retain) NSString *rootURLstring;
@property (retain) NSString *scratchURLstring;
@property (retain) id response;
@property (assign) id document;

- (void)clear;

- (BOOL)prepareInitialPage;
- (void)loadInitialPage;


/*!
 Subclassers can do additional setup if needed. Make sure to call super first.
 */
- (void)prepareActionForUse:(MCReportWebAction *)action request:(NSURLRequest *)request;



/*
 Find routes
 Find scripts
 Load classes
 
 parse URL, see if mcreport: is in prefix
 mcreport:theReport/action?args
 
 
 webReportProperties = {
    urlname = "theReport";
	initialAction = "theFirstAction";
    actions = {
       	theFirstAction = {
 			class = "MyReportActionClassname";
 			method = "theSelectorName";  // 'run' is used by default
 		};
 		theOtherAction = {
 			class = "";
 			method = "";
 		};
 		theOtherOtherAction = {
 			filename = "";
 		};
    };
 };
 
 */


- (IBAction)goBack:(id)sender;



@end
